/* rygel-subtitle-manager.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-subtitle-manager.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Andreas Henriksson <andreas@fatal.se>.
 *
 * Authors: Andreas Henriksson <andreas@fatal.se>
 *          Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
typedef struct _RygelSubtitleManagerPrivate RygelSubtitleManagerPrivate;
enum  {
	RYGEL_SUBTITLE_MANAGER_0_PROPERTY,
	RYGEL_SUBTITLE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* rygel_subtitle_manager_properties[RYGEL_SUBTITLE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	SUBTITLE_MANAGER_ERROR_NO_SUBTITLE
} SubtitleManagerError;
#define SUBTITLE_MANAGER_ERROR subtitle_manager_error_quark ()
struct _RygelSubtitleManager {
	GObject parent_instance;
	RygelSubtitleManagerPrivate * priv;
};

struct _RygelSubtitleManagerClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};


static gpointer rygel_subtitle_manager_parent_class = NULL;
static RygelSubtitleManager* rygel_subtitle_manager_manager;
static RygelSubtitleManager* rygel_subtitle_manager_manager = NULL;

GQuark subtitle_manager_error_quark (void);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
RygelSubtitleManager* rygel_subtitle_manager_new (void);
RygelSubtitleManager* rygel_subtitle_manager_construct (GType object_type);
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void rygel_value_set_subtitle (GValue* value,
                               gpointer v_object);
void rygel_value_take_subtitle (GValue* value,
                                gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_subtitle_manager_get_subtitles (RygelSubtitleManager* self,
                                                    const gchar* uri,
                                                    GError** error);
RygelSubtitle* rygel_subtitle_new (const gchar* mime_type,
                                   const gchar* caption_type);
RygelSubtitle* rygel_subtitle_construct (GType object_type,
                                         const gchar* mime_type,
                                         const gchar* caption_type);
static void rygel_subtitle_manager_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


GQuark
subtitle_manager_error_quark (void)
{
	return g_quark_from_static_string ("subtitle_manager_error-quark");
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


RygelSubtitleManager*
rygel_subtitle_manager_get_default (void)
{
	RygelSubtitleManager* result = NULL;
	RygelSubtitleManager* _tmp0_;
	RygelSubtitleManager* _tmp2_;
	RygelSubtitleManager* _tmp3_;
	_tmp0_ = rygel_subtitle_manager_manager;
	if (_tmp0_ == NULL) {
		RygelSubtitleManager* _tmp1_;
		_tmp1_ = rygel_subtitle_manager_new ();
		_g_object_unref0 (rygel_subtitle_manager_manager);
		rygel_subtitle_manager_manager = _tmp1_;
	}
	_tmp2_ = rygel_subtitle_manager_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


GeeArrayList*
rygel_subtitle_manager_get_subtitles (RygelSubtitleManager* self,
                                      const gchar* uri,
                                      GError** error)
{
	GeeArrayList* result = NULL;
	GFile* video_file = NULL;
	GFile* _tmp0_;
	GFile* directory = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* basename = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gint ext_index = 0;
	const gchar* _tmp5_;
	gint _tmp6_;
	gchar** exts = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint exts_length1;
	gint _exts_size_;
	GeeArrayList* subtitles = NULL;
	GeeArrayList* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GeeArrayList* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	video_file = _tmp0_;
	_tmp1_ = video_file;
	_tmp2_ = g_file_get_parent (_tmp1_);
	directory = _tmp2_;
	_tmp3_ = video_file;
	_tmp4_ = g_file_get_basename (_tmp3_);
	basename = _tmp4_;
	_tmp5_ = basename;
	ext_index = string_last_index_of_char (_tmp5_, (gunichar) '.', 0);
	_tmp6_ = ext_index;
	if (_tmp6_ >= 0) {
		const gchar* _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = basename;
		_tmp8_ = ext_index;
		_tmp9_ = string_slice (_tmp7_, (glong) 0, (glong) _tmp8_);
		_g_free0 (basename);
		basename = _tmp9_;
	}
	_tmp10_ = g_strdup ("srt");
	_tmp11_ = g_strdup ("smi");
	_tmp12_ = g_new0 (gchar*, 2 + 1);
	_tmp12_[0] = _tmp10_;
	_tmp12_[1] = _tmp11_;
	exts = _tmp12_;
	exts_length1 = 2;
	_exts_size_ = exts_length1;
	_tmp13_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, (GDestroyNotify) rygel_subtitle_unref, NULL, NULL, NULL);
	subtitles = _tmp13_;
	_tmp14_ = exts;
	_tmp14__length1 = exts_length1;
	{
		gchar** ext_collection = NULL;
		gint ext_collection_length1 = 0;
		gint _ext_collection_size_ = 0;
		gint ext_it = 0;
		ext_collection = _tmp14_;
		ext_collection_length1 = _tmp14__length1;
		for (ext_it = 0; ext_it < _tmp14__length1; ext_it = ext_it + 1) {
			gchar* _tmp15_;
			gchar* ext = NULL;
			_tmp15_ = g_strdup (ext_collection[ext_it]);
			ext = _tmp15_;
			{
				gchar* filename = NULL;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				GFile* subtitle_file = NULL;
				GFile* _tmp22_;
				const gchar* _tmp23_;
				GFile* _tmp24_;
				_tmp16_ = basename;
				_tmp17_ = g_strconcat (_tmp16_, ".", NULL);
				_tmp18_ = _tmp17_;
				_tmp19_ = ext;
				_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp18_);
				filename = _tmp21_;
				_tmp22_ = directory;
				_tmp23_ = filename;
				_tmp24_ = g_file_get_child (_tmp22_, _tmp23_);
				subtitle_file = _tmp24_;
				{
					gchar* attribs = NULL;
					gchar* _tmp25_;
					GFileInfo* info = NULL;
					GFile* _tmp26_;
					const gchar* _tmp27_;
					GFileInfo* _tmp28_;
					GFileInfo* _tmp29_;
					_tmp25_ = g_strdup (G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
					attribs = _tmp25_;
					_tmp26_ = subtitle_file;
					_tmp27_ = attribs;
					_tmp28_ = g_file_query_info (_tmp26_, _tmp27_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
					info = _tmp28_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (attribs);
						goto __catch80_g_error;
					}
					_tmp29_ = info;
					if (g_file_info_get_attribute_boolean (_tmp29_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
						gchar* content_type = NULL;
						GFileInfo* _tmp30_;
						const gchar* _tmp31_;
						gchar* _tmp32_;
						RygelSubtitle* subtitle = NULL;
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						RygelSubtitle* _tmp35_;
						RygelSubtitle* _tmp36_;
						GFile* _tmp37_;
						gchar* _tmp38_;
						RygelSubtitle* _tmp39_;
						GFileInfo* _tmp40_;
						GeeArrayList* _tmp41_;
						RygelSubtitle* _tmp42_;
						_tmp30_ = info;
						_tmp31_ = g_file_info_get_attribute_string (_tmp30_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
						_tmp32_ = g_strdup (_tmp31_);
						content_type = _tmp32_;
						_tmp33_ = content_type;
						_tmp34_ = ext;
						_tmp35_ = rygel_subtitle_new (_tmp33_, _tmp34_);
						subtitle = _tmp35_;
						_tmp36_ = subtitle;
						_tmp37_ = subtitle_file;
						_tmp38_ = g_file_get_uri (_tmp37_);
						_g_free0 (_tmp36_->uri);
						_tmp36_->uri = _tmp38_;
						_tmp39_ = subtitle;
						_tmp40_ = info;
						_tmp39_->size = (gint64) g_file_info_get_attribute_uint64 (_tmp40_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
						_tmp41_ = subtitles;
						_tmp42_ = subtitle;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp42_);
						_rygel_subtitle_unref0 (subtitle);
						_g_free0 (content_type);
					}
					_g_object_unref0 (info);
					_g_free0 (attribs);
				}
				goto __finally80;
				__catch80_g_error:
				{
					GError* err = NULL;
					GFile* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					GError* _tmp46_;
					const gchar* _tmp47_;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp43_ = subtitle_file;
					_tmp44_ = g_file_get_path (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = err;
					_tmp47_ = _tmp46_->message;
					g_debug ("rygel-subtitle-manager.vala:84: Failed to query file information for %" \
"s: %s", _tmp45_, _tmp47_);
					_g_free0 (_tmp45_);
					_g_error_free0 (err);
				}
				__finally80:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (subtitle_file);
					_g_free0 (filename);
					_g_free0 (ext);
					_g_object_unref0 (subtitles);
					exts = (_vala_array_free (exts, exts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (basename);
					_g_object_unref0 (directory);
					_g_object_unref0 (video_file);
					return NULL;
				}
				_g_object_unref0 (subtitle_file);
				_g_free0 (filename);
				_g_free0 (ext);
			}
		}
	}
	_tmp48_ = subtitles;
	_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
	_tmp50_ = _tmp49_;
	if (_tmp50_ == 0) {
		GError* _tmp51_;
		_tmp51_ = g_error_new_literal (SUBTITLE_MANAGER_ERROR, SUBTITLE_MANAGER_ERROR_NO_SUBTITLE, _ ("No subtitle available"));
		_inner_error_ = _tmp51_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (subtitles);
		exts = (_vala_array_free (exts, exts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (basename);
		_g_object_unref0 (directory);
		_g_object_unref0 (video_file);
		return NULL;
	}
	result = subtitles;
	exts = (_vala_array_free (exts, exts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (basename);
	_g_object_unref0 (directory);
	_g_object_unref0 (video_file);
	return result;
}


RygelSubtitleManager*
rygel_subtitle_manager_construct (GType object_type)
{
	RygelSubtitleManager * self = NULL;
	self = (RygelSubtitleManager*) g_object_new (object_type, NULL);
	return self;
}


RygelSubtitleManager*
rygel_subtitle_manager_new (void)
{
	return rygel_subtitle_manager_construct (RYGEL_TYPE_SUBTITLE_MANAGER);
}


static void
rygel_subtitle_manager_class_init (RygelSubtitleManagerClass * klass)
{
	rygel_subtitle_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_manager_finalize;
}


static void
rygel_subtitle_manager_instance_init (RygelSubtitleManager * self)
{
}


static void
rygel_subtitle_manager_finalize (GObject * obj)
{
	RygelSubtitleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager);
	G_OBJECT_CLASS (rygel_subtitle_manager_parent_class)->finalize (obj);
}


/**
 * Provides subtitles for videos.
 */
GType
rygel_subtitle_manager_get_type (void)
{
	static volatile gsize rygel_subtitle_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitleManager), 0, (GInstanceInitFunc) rygel_subtitle_manager_instance_init, NULL };
		GType rygel_subtitle_manager_type_id;
		rygel_subtitle_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitleManager", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_manager_type_id__volatile, rygel_subtitle_manager_type_id);
	}
	return rygel_subtitle_manager_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



