/* rygel-time-utils.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-time-utils.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_TIME_UTILS (rygel_time_utils_get_type ())
#define RYGEL_TIME_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TIME_UTILS, RygelTimeUtils))
#define RYGEL_TIME_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TIME_UTILS, RygelTimeUtilsClass))
#define RYGEL_IS_TIME_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TIME_UTILS))
#define RYGEL_IS_TIME_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TIME_UTILS))
#define RYGEL_TIME_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TIME_UTILS, RygelTimeUtilsClass))

typedef struct _RygelTimeUtils RygelTimeUtils;
typedef struct _RygelTimeUtilsClass RygelTimeUtilsClass;
typedef struct _RygelTimeUtilsPrivate RygelTimeUtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelParamSpecTimeUtils RygelParamSpecTimeUtils;

struct _RygelTimeUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTimeUtilsPrivate * priv;
};

struct _RygelTimeUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTimeUtils *self);
};

struct _RygelParamSpecTimeUtils {
	GParamSpec parent_instance;
};


static gpointer rygel_time_utils_parent_class = NULL;

gpointer rygel_time_utils_ref (gpointer instance);
void rygel_time_utils_unref (gpointer instance);
GParamSpec* rygel_param_spec_time_utils (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void rygel_value_set_time_utils (GValue* value,
                                 gpointer v_object);
void rygel_value_take_time_utils (GValue* value,
                                  gpointer v_object);
gpointer rygel_value_get_time_utils (const GValue* value);
GType rygel_time_utils_get_type (void) G_GNUC_CONST;
gint64 rygel_time_utils_time_from_string (const gchar* str);
gchar* rygel_time_utils_time_to_string (gint64 time);
RygelTimeUtils* rygel_time_utils_construct (GType object_type);
static void rygel_time_utils_finalize (RygelTimeUtils * obj);


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


gint64
rygel_time_utils_time_from_string (const gchar* str)
{
	gint64 result = 0LL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	guint64 msecs = 0ULL;
	gchar* time_str = NULL;
	gchar* _tmp0_;
	gint sign = 0;
	const gchar* _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = g_strdup (str);
	time_str = _tmp0_;
	sign = 1;
	switch (string_get (str, (glong) 0)) {
		case '-':
		{
			gchar* _tmp1_;
			sign = -1;
			_tmp1_ = string_substring (str, (glong) 1, (glong) -1);
			_g_free0 (time_str);
			time_str = _tmp1_;
			break;
		}
		case '+':
		{
			gchar* _tmp2_;
			_tmp2_ = string_substring (str, (glong) 1, (glong) -1);
			_g_free0 (time_str);
			time_str = _tmp2_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp3_ = time_str;
	sscanf (_tmp3_, "%llu:%2llu:%2llu.%3llu", &hours, &minutes, &seconds, &msecs);
	_tmp4_ = sign;
	result = _tmp4_ * ((((gint64) (((hours * 3600) + (minutes * 60)) + seconds)) * G_TIME_SPAN_SECOND) + (((gint64) msecs) * G_TIME_SPAN_MILLISECOND));
	_g_free0 (time_str);
	return result;
}


gchar*
rygel_time_utils_time_to_string (gint64 time)
{
	gchar* result = NULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	guint64 totsecs = 0ULL;
	guint64 msecs = 0ULL;
	gchar* sign = NULL;
	gchar* _tmp0_;
	guint64 _tmp2_;
	guint64 _tmp3_;
	guint64 _tmp4_;
	const gchar* _tmp5_;
	guint64 _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = g_strdup ("");
	sign = _tmp0_;
	if (time < ((gint64) 0)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("-");
		_g_free0 (sign);
		sign = _tmp1_;
		time = -time;
	}
	hours = (guint64) ((time / G_TIME_SPAN_SECOND) / 3600);
	seconds = (guint64) ((time / G_TIME_SPAN_SECOND) % 3600);
	_tmp2_ = seconds;
	minutes = _tmp2_ / 60;
	_tmp3_ = seconds;
	seconds = _tmp3_ % 60;
	_tmp4_ = seconds;
	totsecs = (((hours * 3600) + (minutes * 60)) + _tmp4_) * G_TIME_SPAN_SECOND;
	msecs = (time - totsecs) / G_TIME_SPAN_MILLISECOND;
	_tmp5_ = sign;
	_tmp6_ = seconds;
	_tmp7_ = g_strdup_printf ("%s%llu:%.2llu:%.2llu.%.3llu", _tmp5_, hours, minutes, _tmp6_, msecs);
	result = _tmp7_;
	_g_free0 (sign);
	return result;
}


RygelTimeUtils*
rygel_time_utils_construct (GType object_type)
{
	RygelTimeUtils* self = NULL;
	self = (RygelTimeUtils*) g_type_create_instance (object_type);
	return self;
}


static void
rygel_value_time_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
rygel_value_time_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_time_utils_unref (value->data[0].v_pointer);
	}
}


static void
rygel_value_time_utils_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_time_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
rygel_value_time_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
rygel_value_time_utils_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelTimeUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_time_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
rygel_value_time_utils_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	RygelTimeUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_time_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
rygel_param_spec_time_utils (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	RygelParamSpecTimeUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_TIME_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
rygel_value_get_time_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TIME_UTILS), NULL);
	return value->data[0].v_pointer;
}


void
rygel_value_set_time_utils (GValue* value,
                            gpointer v_object)
{
	RygelTimeUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TIME_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TIME_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_time_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_time_utils_unref (old);
	}
}


void
rygel_value_take_time_utils (GValue* value,
                             gpointer v_object)
{
	RygelTimeUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TIME_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TIME_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_time_utils_unref (old);
	}
}


static void
rygel_time_utils_class_init (RygelTimeUtilsClass * klass)
{
	rygel_time_utils_parent_class = g_type_class_peek_parent (klass);
	((RygelTimeUtilsClass *) klass)->finalize = rygel_time_utils_finalize;
}


static void
rygel_time_utils_instance_init (RygelTimeUtils * self)
{
	self->ref_count = 1;
}


static void
rygel_time_utils_finalize (RygelTimeUtils * obj)
{
	RygelTimeUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TIME_UTILS, RygelTimeUtils);
	g_signal_handlers_destroy (self);
}


GType
rygel_time_utils_get_type (void)
{
	static volatile gsize rygel_time_utils_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_time_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_time_utils_init, rygel_value_time_utils_free_value, rygel_value_time_utils_copy_value, rygel_value_time_utils_peek_pointer, "p", rygel_value_time_utils_collect_value, "p", rygel_value_time_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTimeUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_time_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTimeUtils), 0, (GInstanceInitFunc) rygel_time_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_time_utils_type_id;
		rygel_time_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTimeUtils", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_time_utils_type_id__volatile, rygel_time_utils_type_id);
	}
	return rygel_time_utils_type_id__volatile;
}


gpointer
rygel_time_utils_ref (gpointer instance)
{
	RygelTimeUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
rygel_time_utils_unref (gpointer instance)
{
	RygelTimeUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_TIME_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



