%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved via the world wide web at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Initial Developer of the Original Code is Ericsson Utvecklings AB.
%% Portions created by Ericsson are Copyright 1999, Ericsson Utvecklings
%% AB. All Rights Reserved.''
%% 
%%     $Id$
%%
%%
%%    Module documentation:
%%    ---------------------
%%
%%    Header file for the Erlang IDL compiler. Contains all records
%%    used in the parse tree
%%
%%
%%------------------------------------------------------------



%%------------------------------------------------------------

-record(module,		{id, body}).
-record(interface,	{id, inherit, body, inherit_body, tk}).
-record(forward,	{id, tk}).
-record(const,		{type, id, val, tk}).
-record(type_dcl,	{type, tk}).
-record(typedef,	{type, id, tk}).
-record(struct,		{id, body, tk}).
-record(member,		{type, id}).
-record(union,		{id, type, body, tk}).
-record(case_dcl,	{label, id, type}).
-record(enum,		{id, body, tk}).
-record(enumerator,	{id}).
-record(sequence,	{type, length=0}).
-record(string,		{length=0}).
-record(array,		{id, size}).
-record(attr,		{readonly, type, id, tk}).
-record(except,		{id, body, tk}).
-record(op,		{oneway, type, id, params, raises, ctx, tk}).
-record(param,		{inout, type, id, tk}).

%% NON-STANDARD
-record(preproc,	{cat, id, aux}).
-record(pragma,	        {type, to, apply}).










